/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.capabilities;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;

public final class CapabilityDispatcher
implements INBTSerializable<fy>,
ICapabilityProvider {
    private final FastCapability[] fastCapabilities;
    private int writerCount = 0;

    public CapabilityDispatcher(Map<nf, ICapabilityProvider> list) {
        this(list, null);
    }

    public CapabilityDispatcher(Map<nf, ICapabilityProvider> list, @Nullable ICapabilityProvider parent) {
        int indexOffset = 0;
        this.fastCapabilities = new FastCapability[parent != null ? list.size() + 1 : list.size()];
        if (parent != null) {
            FastCapability fastCapability = new FastCapability(parent);
            if (parent instanceof INBTSerializable) {
                fastCapability.writer = (INBTSerializable)((Object)parent);
                fastCapability.name = "Parent";
                ++this.writerCount;
            }
            this.fastCapabilities[indexOffset++] = fastCapability;
        }
        for (Map.Entry<nf, ICapabilityProvider> entry : list.entrySet()) {
            ICapabilityProvider prov = entry.getValue();
            FastCapability fastCapability = new FastCapability(prov);
            if (prov instanceof INBTSerializable) {
                fastCapability.writer = (INBTSerializable)((Object)prov);
                fastCapability.name = entry.getKey().toString();
                ++this.writerCount;
            }
            this.fastCapabilities[indexOffset++] = fastCapability;
        }
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable fa facing) {
        for (FastCapability fastCapability : this.fastCapabilities) {
            if (!fastCapability.cap.hasCapability(capability, facing)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable fa facing) {
        for (FastCapability fastCapability : this.fastCapabilities) {
            T ret = fastCapability.cap.getCapability(capability, facing);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    @Override
    public fy serializeNBT() {
        fy nbt = new fy();
        for (FastCapability fastCapability : this.fastCapabilities) {
            if (fastCapability.writer == null) continue;
            nbt.a(fastCapability.name, fastCapability.writer.serializeNBT());
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(fy nbt) {
        for (FastCapability fastCapability : this.fastCapabilities) {
            if (fastCapability.writer == null || !nbt.e(fastCapability.name)) continue;
            fastCapability.writer.deserializeNBT(nbt.c(fastCapability.name));
        }
    }

    public boolean areCompatible(CapabilityDispatcher other) {
        if (other == null) {
            return this.writerCount == 0;
        }
        if (this.writerCount == 0) {
            return other.writerCount == 0;
        }
        return this.serializeNBT().equals((Object)other.serializeNBT());
    }

    static class FastCapability {
        public ICapabilityProvider cap;
        public INBTSerializable<gn> writer;
        public String name;

        public FastCapability(ICapabilityProvider cap) {
            this.cap = cap;
        }
    }
}

